# ALGO ARTIS プログラミングコンテスト 2025 師走 抽選プログラム
# Copyright (c) 2021 株式会社THIRD
"""
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""


# プログラム内のパラメータを変更した上でPython3上で実行します。
# 主催者環境での動作結果を正とします。

import random

# 正の点数を取った人の人数を入力するために、ゼロ点の人の順位を入力する方が楽です。
scoreZeroRank = 1001
submitterCount = scoreZeroRank - 1

# ヒューリスティックコンテストの場合： 上位3名分のスコアを入れます。4位以下のスコアは無視されます。
# アルゴリズムコンテストの場合： 順位表に表示されている最初3問(通常はA問題B問題C問題)の正解者数を入れます。4問目以降は無視されます。（変数名はヒューリスティックコンテストのままtopScoresを用います）
topScores = [100, 90, 80, 70, 60, 50, 40, 30, 20, 10]

# AA賞の獲得人数です。
# ALGO ARTIS社員が参加できなかった場合およびALGO ARTIS社員より上位の参加者が3名に満たない場合に変更します。
aaPrizeCount = 12

# ここより上のパラメータを変更した上で実行します。

# 固定
lotteryCount = 24 + (12 - aaPrizeCount) * 2
prizes = [
    (1, 50000),
    (2, 30000),
    (3, 20000),
    (4, 10000),
    (5, 10000),
] + [(-1, 5000)] * lotteryCount


def lottery(topScores, submitterCount, prizes):
    scoreSum = sum(int(score) for score in topScores[:3])
    rng = random.Random(scoreSum)
    already = {rank for rank, amount in prizes if 0 < rank}
    lots = [
        (1000000 // rank, rank)
        for rank in range(1, submitterCount + 1)
        if rank not in already
    ]
    for index, (rank, amount) in enumerate(prizes):
        if 0 <= rank:
            continue
        sum_weights = sum(weight for weight, rank in lots)
        R = rng.randrange(sum_weights)
        for i, (weight, rank) in enumerate(lots):
            if R < weight:
                prizes[index] = (rank,) + prizes[index][1:]
                lots.pop(i)
                break
            R -= weight


if __name__ == "__main__":
    lottery(topScores, submitterCount, prizes)

    prizes.sort()

    totalAmount = 0
    for rank, amount in prizes:
        print(f"{rank}位: {amount}円分Amazonギフト券")
        totalAmount += amount
    print()
    print(f"総額: {totalAmount}円分Amazonギフト券")
